package editor;

import game.CustomImageDataII;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;

import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class NewConveyorPaletteObjectWizard extends JPanel implements SecondaryOKValidation {
	private CustomAnimationPanel cap;
	private JCheckBox passThru;
	//private JCheckBox showCommentary;
	
//	private JTextField widthField;
//	private JTextField heightField;
	private JTextField speedField;
	
	private JRadioButton leftButton;
	private JRadioButton rightButton;
	
	
	
	public NewConveyorPaletteObjectWizard(JDialog theParent) {
		
		cap = new CustomAnimationPanel(theParent, "", "Conveyor");
		cap.setAdditionalValidations(this);
		
		this.setLayout(new GridLayout(1, 2));
		
		this.add(cap);
		
		JPanel rightSidePanel = new JPanel();
		rightSidePanel.setLayout(new GridLayout(5, 1));
		
		rightSidePanel.add(new JPanel());
		
		passThru = new JCheckBox("should be pass-through?");
		JPanel passThruPanel = new JPanel(new FlowLayout());
		passThruPanel.add(passThru);
		rightSidePanel.add(passThruPanel);
		
		JPanel dimensionsPanel = new JPanel(new GridLayout(1, 2));
//		JPanel widthPanel = new JPanel(new FlowLayout());
//		widthPanel.add(new JLabel("Width:"));
//		widthField = new JTextField(3);
//		widthPanel.add(widthField);
//		dimensionsPanel.add(widthPanel);
//		JPanel heightPanel = new JPanel(new FlowLayout());
//		heightPanel.add(new JLabel("Height:"));
//		heightField = new JTextField(3);
//		heightPanel.add(heightField);
//		dimensionsPanel.add(heightPanel);
		rightSidePanel.add(dimensionsPanel);
		
		
		
		JPanel speedPanel = new JPanel(new FlowLayout());
		speedPanel.add(new JLabel("Speed:"));
		speedField = new JTextField(3);
		speedField.setText("1");
		speedPanel.add(speedField);
		rightSidePanel.add(speedPanel);
		
		
		JPanel dirPanel = new JPanel(new FlowLayout());
		ButtonGroup group = new ButtonGroup();
		leftButton = new JRadioButton("Conveyor goes left");
		dirPanel.add(leftButton);
		group.add(leftButton);
		rightButton = new JRadioButton("Conveyor goes right");
		dirPanel.add(rightButton);
		group.add(rightButton);
		rightButton.setSelected(true);
		rightSidePanel.add(dirPanel);
		
		
		this.add(rightSidePanel);
	}
	
	
	public NewConveyorPaletteObjectWizard(JDialog theParent, CustomImageDataII [] theAnimation, boolean thePassThruFlag, boolean theFacesLeftFlag, int theSpeed) {
		
		cap = new CustomAnimationPanel(theParent, "", "Conveyor", theAnimation);
		cap.setAdditionalValidations(this);
		
		this.setLayout(new GridLayout(1, 2));
		
		this.add(cap);
		
		JPanel rightSidePanel = new JPanel();
		rightSidePanel.setLayout(new GridLayout(5, 1));
		
		rightSidePanel.add(new JPanel());
		
		passThru = new JCheckBox("should be pass-through?");
		if(thePassThruFlag)
			passThru.setSelected(true);
		JPanel passThruPanel = new JPanel(new FlowLayout());
		passThruPanel.add(passThru);
		rightSidePanel.add(passThruPanel);
		
		JPanel dimensionsPanel = new JPanel(new GridLayout(1, 2));
//		JPanel widthPanel = new JPanel(new FlowLayout());
//		widthPanel.add(new JLabel("Width:"));
//		widthField = new JTextField(3);
//		widthField.setText(Integer.toString(theWidth));
//		widthPanel.add(widthField);
//		dimensionsPanel.add(widthPanel);
//		JPanel heightPanel = new JPanel(new FlowLayout());
//		heightPanel.add(new JLabel("Height:"));
//		heightField = new JTextField(3);
//		heightField.setText(Integer.toString(theHeight));
//		heightPanel.add(heightField);
//		dimensionsPanel.add(heightPanel);
		rightSidePanel.add(dimensionsPanel);
		
		
		
		JPanel speedPanel = new JPanel(new FlowLayout());
		speedPanel.add(new JLabel("Speed:"));
		speedField = new JTextField(3);
		speedField.setText(Integer.toString(theSpeed));
		speedPanel.add(speedField);
		rightSidePanel.add(speedPanel);
		
		
		JPanel dirPanel = new JPanel(new FlowLayout());
		ButtonGroup group = new ButtonGroup();
		leftButton = new JRadioButton("Conveyor goes left");
		dirPanel.add(leftButton);
		group.add(leftButton);
		if(theFacesLeftFlag)
			leftButton.setSelected(true);
		rightButton = new JRadioButton("Conveyor goes right");
		dirPanel.add(rightButton);
		group.add(rightButton);
		if(!theFacesLeftFlag)
			rightButton.setSelected(true);
		rightSidePanel.add(dirPanel);
		

		this.add(rightSidePanel);
	}
	
	
	public CustomAnimationPanel getAnimPanel() {
		return cap;
	}
	
	public boolean shouldBePassThru() {
		return passThru.isSelected();
	}
	
//	public boolean shouldEnableCommentary() {
//		return showCommentary.isSelected();
//	}
	
	
	
	public static void main(String [] args) {
		
		
		JDialog frame = new JDialog();
		
		NewConveyorPaletteObjectWizard panel = new NewConveyorPaletteObjectWizard(frame);
		frame.setContentPane(panel);
		
		frame.setModal(true);
		
		frame.setSize(new Dimension(900, 700));
		
		frame.setVisible(true);
		
		
		frame.dispose();
		
	}
	
	public CustomImageDataII [] getImages() {
		return cap.getFinalResult();
	}
	
	public boolean isFacingLeft() {
		return leftButton.isSelected();
	}
	
	public boolean isPassThru() {
		return passThru.isSelected();
	}
	
	public int getSpeed() {
		return Integer.parseInt(speedField.getText().trim());
	}


	@Override
	public String performSecondaryOkValidationsReturnErrors() {
		
//		System.out.println();
		try {
			getSpeed();
		} catch(Exception e) {
			return "The speed is not set to a number";
		}
		
		return null;
	}
}
